//
// Cforall Version 1.0.0 Copyright (C) 2017 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// references.c --
//
// Author           : Rob Schluntz
// Created On       : Wed Aug 23 16:11:50 2017
// Last Modified By : Rob Schluntz
// Last Modified On : Wed Aug 23 16:12:03
// Update Count     : 2
//

struct Y { int i; };
void ?{}(Y & y) { printf("Default constructing a Y\n"); }
void ?{}(Y & y, Y other) { printf("Copy constructing a Y\n"); }
void ^?{}(Y & y) { printf("Destructing a Y\n"); }
Y ?=?(Y & y, Y other) { printf("Assigning a Y\n"); return y; }

struct X { Y & r; Y y; };
void ?{}(X & x) {
	// ensure that r is not implicitly constructed
}
void ?{}(X & x, X other) {
	// ensure that r is not implicitly constructed
}
void ^?{}(X & x) {
	// ensure that r is not implicitly destructed
}
X ?=?(X & x, X other) { return x; }

// test user-defined reference-returning function
int & toref( int * p ) { return *p; }
// test user-defined reference-parameter function
int * toptr( int & r ) { return &r; }

int main() {
	int x = 123456, *p1 = &x, **p2 = &p1, ***p3 = &p2,
		&r1 = x,    &&r2 = r1,   &&&r3 = r2;
	***p3 = 3;                          // change x
	**p3 = &x;                          // change p1
	*p3 = &p1;                          // change p2
	int y, z, & ar[3] = { x, y, z };    // initialize array of references

	// test that basic reference properties are true - r1 should be an alias for x
	printf("%d %d %d\n", x, r1, &x == &r1);
	r1 = 12;
	printf("%d %d %d\n", x, r1, &x == &r1);

	// test that functions using basic references work
	printf("%d %d %d %d\n", toref(&x), toref(p1), toptr(r1) == toptr(x), toptr(r1) == &x);

	// test that reference members are not implicitly constructed/destructed/assigned
	X x1, x2 = x1;
	x1 = x2;
}

// Local Variables: //
// tab-width: 4 //
// End: //

