#!lua

-- Additional Linux libs: "X11", "Xxf86vm", "Xi", "Xrandr", "stdc++"

includeDirList = {
	"src/",
	"../",
}

libDirectories = {

}


if os.get() == "linux" then
    linkLibs = {
	"bsd"
    }
end

-- Build Options:
buildOptions = {"\n  CC = cfa\n  CXX = cfa"}

solution "strings"
	configurations  { "debug", "release",
				"cproc-debug", "cproc-release",
				"cfa-debug", "cfa-release" }

	project "string-test"
		kind "ConsoleApp"
		language "C"
		location "build"
		objdir "build"
		targetdir "."
		buildoptions (buildOptions)
		defines {	"bool=_Bool",
				"\"true=((_Bool)(const signed int)1)\"",
				"\"false=((_Bool)(const signed int)0)\"",
				"_GNU_SOURCE",
				"__cforall",
				"USE_BSD_LIB"
			}
		libdirs (libDirectories)
		links (linkLibs)
		linkoptions (linkOptionList)
		includedirs (includeDirList)
		files { "src/**.c" }

	configuration "debug"
		defines { "DEBUG" }
		flags { "Symbols" }

	configuration "release"
		defines { "NDEBUG" }
		flags { "Optimize" }

	configuration "cproc-debug"
		buildoptions ({"-E"})
		linkoptions ({"-E"})
	      defines { "DEBUG" }
	      flags { "Symbols" }

	configuration "cproc-release"
		buildoptions ({"-E"})
		linkoptions ({"-E"})
	      defines { "DEBUG" }
	      flags { "Symbols" }

	configuration "cfa-debug"
		linkoptions ({"-E"})
		files { "build/cproc-debug/*.o" }
	      defines { "DEBUG" }
	      flags { "Symbols" }

	configuration "cfa-release"
		linkoptions ({"-E"})
		files { "build/cproc-debug/*.o" }
	      defines { "DEBUG" }
	      flags { "Symbols" }
