#pragma once

#if NDEBUG

#define assert(x)
#define assertf(x, ...)

#else

#ifdef __cforall
extern "C" {
#endif
#include <stdlib.h>
#include <stdio.h>
#ifdef USE_BSD_LIB
#include <bsd/stdlib.h>
#endif
#ifdef __cforall
}
#endif

#ifdef USE_BSD_LIB
#define OUT_TXT "%s: %s:%i: %s: Assertion \'%s\' failed.\n", getprogname()
#else
#define OUT_TXT "%s:%i: %s: Assertion \'%s\' failed.\n"
#endif

#define assert(x) do {\
	if(!(x)) {\
		printf(OUT_TXT, __FILE__, __LINE__, __PRETTY_FUNCTION__, #x);\
		abort();\
	}}while(1 == 2)\


#define assertf(x, ...) do {\
	if(!(x)) {\
		printf(OUT_TXT, __FILE__, __LINE__, __PRETTY_FUNCTION__, #x);\
		printf(__VA_ARGS__);\
		abort();\
	}}while(1 == 2)\

#endif 
