//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FlattenTuple.cc -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon May 18 11:26:56 2015
// Update Count     : 1
//

#include <list>
#include <vector>
#include <cassert>
#include <algorithm>

#include "FlattenTuple.h"

namespace Tuples {
	FlattenTuple::FlattenTuple() {
	}

	FlattenTuple::~FlattenTuple() {
	}

	Expression *FlattenTuple::mutate( TupleExpr *tupleExpr ) {
		CollectArgs c;

		acceptAll( tupleExpr->get_exprs(), c );
		tupleExpr->set_exprs( c.get_args() );

		return tupleExpr;
	}

	void FlattenTuple::CollectArgs::visit( UntypedExpr         *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( NameExpr            *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( CastExpr            *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( AddressExpr         *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( UntypedMemberExpr   *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( MemberExpr          *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( VariableExpr        *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( ConstantExpr        *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( SizeofExpr          *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( AlignofExpr         *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( UntypedOffsetofExpr *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( OffsetofExpr        *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( AttrExpr            *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( LogicalExpr         *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( ConditionalExpr     *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( CommaExpr           *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( TypeExpr            *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }
	void FlattenTuple::CollectArgs::visit( UntypedValofExpr    *expr )  {  currentArgs.insert( currentArgs.end(), expr );  }

	void FlattenTuple::CollectArgs::visit( TupleExpr *tupleExpr) {
		acceptAll( tupleExpr->get_exprs(), *this );
		//currentArgs.splice( currentArgs.end(), c.get_args() );
	}
} // namespace Tuples

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
