//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// iostream.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Feb 17 14:19:56 2016
// Update Count     : 76
//

#include "iostream"

extern "C" {
#include <stdio.h>
#include <string.h>										// strlen
#include <float.h>										// DBL_DIG, LDBL_DIG
#include <complex.h>									// creal, cimag
}

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, char c ) {
	return write( os, &c, 1 );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, int i ) {
	char buffer[32];
	return write( os, buffer, sprintf( buffer, "%d", i ) );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, unsigned int i ) {
	char buffer[32];
	return write( os, buffer, sprintf( buffer, "%u", i ) );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, long int i ) {
	char buffer[32];
	return write( os, buffer, sprintf( buffer, "%ld", i ) );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, long long int i ) {
	char buffer[32];
	return write( os, buffer, sprintf( buffer, "%lld", i ) );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, unsigned long int i ) {
	char buffer[32];
	return write( os, buffer, sprintf( buffer, "%lu", i ) );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, unsigned long long int i ) {
	char buffer[32];
	return write( os, buffer, sprintf( buffer, "%llu", i ) );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, float f ) {
	char buffer[32];
	return write( os, buffer, sprintf( buffer, "%g", f ) );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, double d ) {
	char buffer[32];
	return write( os, buffer, sprintf( buffer, "%.*lg", DBL_DIG, d ) );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, long double d ) {
	char buffer[32];
	return write( os, buffer, sprintf( buffer, "%.*Lg", LDBL_DIG, d ) );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, float _Complex c ) {
	return os | crealf( c ) | (cimagf( c ) < 0 ? "" : "+") | cimagf( c ) | 'i';
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, double _Complex c ) {
	return os | creal( c ) | (cimag( c ) < 0 ? "" : "+") | cimag( c ) | 'i';
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, long double _Complex c ) {
	return os | creall( c ) | (cimagl( c ) < 0 ? "" : "+") | cimagl( c ) | 'i';
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, const void *p ) {
	char buffer[32];
	return write( os, buffer, sprintf( buffer, "%p", p ) );
} // ?|?

forall( dtype ostype | ostream( ostype ) )
ostype * ?|?( ostype *os, const char *cp ) {
	return write( os, cp, strlen( cp ) );
} // ?|?


forall( dtype ostype, dtype retostype | ostream( ostype ) | ostream( retostype ) ) 
retostype * ?|?( ostype *os, retostype * (*manip)(ostype*) ) {
  return manip( os );
}

forall( dtype ostype | ostream( ostype ) ) 
ostype * endl( ostype * os ) {
	os | "\n";
	flush( os );
	return os;
} // endl

//---------------------------------------

forall( type elt_type | writeable( elt_type ), type iterator_type | iterator( iterator_type, elt_type ),
		dtype os_type | ostream( os_type ) )
void write( iterator_type begin, iterator_type end, os_type *os ) {
	void print( elt_type i ) { os | i | ' '; }
	for_each( begin, end, print );
} // ?|?

forall( type elt_type | writeable( elt_type ), type iterator_type | iterator( iterator_type, elt_type ),
		dtype os_type | ostream( os_type ) )
void write_reverse( iterator_type begin, iterator_type end, os_type *os ) {
	void print( elt_type i ) { os | i | ' '; }
	for_each_reverse( begin, end, print );
} // ?|?

//---------------------------------------

forall( dtype istype | istream( istype ) )
istype * ?|?( istype *is, char *cp ) {
	return read( is, cp, 1 );
} // ?|?

forall( dtype istype | istream( istype ) )
istype * ?|?( istype *is, int *ip ) {
	return get( is, ip );
} // ?|?

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa iostream.c" //
// End: //
