// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
// 
// CtxSwitch-arm.S -- 
// 
// Author           : Peter A. Buhr
// Created On       : Sun Aug 16 07:50:13 2020
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 20 18:43:51 2020
// Update Count     : 24
// 

// The context switch routine requires the initial the stack of a thread to
// look like the thread has saved its context in the normal manner.

// Offsets must synchronized with the __stack_context_t in invoke.h.

#define PTR_BYTE	8
#define SP_OFFSET	( 0 * PTR_BYTE )
#define FP_OFFSET	( 1 * PTR_BYTE )

// Context switch between coroutines/tasks.
//   void __cfactx_switch( struct __stack_context_t * from, struct __stack_context_t * to ) ;
// Arguments "from" in register x0, "to" in register x1.

#define SAVE		20 * 8

	.file "CtxSwitch-arm.S"
	.text
	.align 2
	.global __cfactx_switch
	.type __cfactx_switch, @function
__cfactx_switch:

	sub  sp, sp, #SAVE					// push stack

	// Save volatile GP registers x19-x30 on the stack.

	stp  x19, x20, [sp, #0x00]
	stp  x21, x22, [sp, #0x10]
	stp  x23, x24, [sp, #0x20]
	stp  x25, x26, [sp, #0x30]
	stp  x27, x28, [sp, #0x40]
	stp  x29, x30, [sp, #0x50]			// x29 => fp

	// Save volatile SIMD/FPU registers d8-d15 on the stack.

	stp  d8,  d9,  [sp, #0x60]
	stp  d10, d11, [sp, #0x70]
	stp  d12, d13, [sp, #0x80]
	stp  d14, d15, [sp, #0x90]

	// Save old context in the "from" area.

	mov  x4, sp							// cannot store sp directly
	str  x4, [x0, #SP_OFFSET]
	str  fp, [x0, #FP_OFFSET]

	// Load new context from the "to" area.

	ldr  fp, [x1, #FP_OFFSET]
	ldr  x4, [x1, #SP_OFFSET]
	mov  sp, x4							// cannot store sp directly

	// Load volatile GP registers x19-x30 from the stack.

	ldp  x19, x20, [sp, #0x00]
	ldp  x21, x22, [sp, #0x10]
	ldp  x23, x24, [sp, #0x20]
	ldp  x25, x26, [sp, #0x30]
	ldp  x27, x28, [sp, #0x40]
	ldp  x29, x30, [sp, #0x50]
	
	// Load volatile SIMD/FPU registers d8-d15 from the stack.

	ldp  d8,  d9,  [sp, #0x60]
	ldp  d10, d11, [sp, #0x70]
	ldp  d12, d13, [sp, #0x80]
	ldp  d14, d15, [sp, #0x90]

	add  sp, sp, #SAVE					// pop stack
	ret									// return to new thread (mov pc, x30)

	.size __cfactx_switch, .-__cfactx_switch
	.section .note.GNU-stack,"",%progbits // mark no executable stack needed

// Stub to create new stacks which can be context switched to
//   void __cfactx_invoke_stub( void );

	.text
	.align 2
	.global __cfactx_invoke_stub
	.type __cfactx_invoke_stub, @function
__cfactx_invoke_stub:
	mov x0, x19							// load main as parameter 0
	mov x1, x20							// load this as parameter 1
	mov x30, x21						// load coroutine invoke routine
	ret									//   and jmp to it (mov pc, x30)
	.size __cfactx_invoke_stub, .-__cfactx_invoke_stub

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
