//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// lex.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Sat Sep 22 08:58:10 2001
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Aug 21 11:28:47 2016
// Update Count     : 347
//

#ifndef PARSER_LEX_H
#define PARSER_LEX_H

int yylex();
void yyerror( const char * );

#include <string>
#include "ParseNode.h"
// External declarations for information sharing between lexer and scanner
class TypedefTable;
extern TypedefTable typedefTable;

// current location in the input
extern int yylineno;
extern char *yyfilename;

struct Location {
    char *file;
    int line;
}; // Location

struct Token {
    std::string *str;									// must be pointer as used in union
    Location loc;

    operator std::string *() { return str; }
}; // Token

#endif // PARSER_LEX_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
