//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// parseutility.cc --
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 15:30:39 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Jun 28 21:08:59 2017
// Update Count     : 6
//

#include "parserutility.h"
#include "SynTree/Type.h"
#include "SynTree/Expression.h"

// rewrite
//    if ( x ) ...
// as
//    if ( (int)(x != 0) ) ...

Expression *notZeroExpr( Expression *orig ) {
	UntypedExpr *comparison = new UntypedExpr( new NameExpr( "?!=?" ) );
	comparison->get_args().push_back( orig );
	comparison->get_args().push_back( new ConstantExpr( Constant( new ZeroType( emptyQualifiers ), "0", (unsigned long long int)0 ) ) );
	return new CastExpr( comparison, new BasicType( Type::Qualifiers(), BasicType::SignedInt ) );
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
