//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ParseNode.cc -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 13:26:29 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Jun  3 11:17:58 2015
// Update Count     : 4
// 

#include "ParseNode.h"
using namespace std;

// Builder
int ParseNode::indent_by = 4;

ParseNode::ParseNode( void ) : next( 0 ) {};
ParseNode::ParseNode( string _name ) : name( _name ), next( 0 ) {}

ParseNode *ParseNode::set_name( string _name ) {
	name = _name;
	return this;
}

ParseNode *ParseNode::set_name( string *_name ) {
	name = *_name; // deep copy
	delete _name;

	return this;
}

ParseNode::~ParseNode( void ) {
	delete next;
};

string ParseNode::get_name( void ) {
	return name;
}

ParseNode *ParseNode::get_link( void ) const {
	return next;
}

ParseNode *ParseNode::get_last(void) {
	ParseNode *current = this;

	while ( current->get_link() != 0 )
	current = current->get_link();

	return current;
}

ParseNode *ParseNode::set_link( ParseNode *_next ) {
	ParseNode *follow;

	if ( _next == 0 ) return this;

	for ( follow = this; follow->next != 0; follow = follow->next );
	follow->next = _next;

	return this;
}

const string ParseNode::get_name( void ) const {
	return name;
}

void ParseNode::print( std::ostream &os, int indent ) const {}


void ParseNode::printList( std::ostream &os, int indent ) const {
	print( os, indent );

	if ( next ) {
		next->printList( os, indent );
	}
}

ParseNode &ParseNode::operator,( ParseNode &p ) {
	set_link( &p );

	return *this;
}

ParseNode *mkList( ParseNode &pn ) {
	// it just relies on `operator,' to take care of the "arguments" and provides a nice interface to an awful-looking
	// address-of, rendering, for example (StatementNode *)(&(*$5 + *$7)) into (StatementNode *)mkList(($5, $7))
	// (although "nice" is probably not the word)
	return &pn;
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
