//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Generate.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jun  2 11:21:06 2015
// Update Count     : 2
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <list>

#include "Generate.h"
#include "SynTree/Declaration.h"
#include "CodeGenerator.h"

using namespace std;

namespace CodeGen {
	void generate( std::list< Declaration* > translationUnit, std::ostream &os, bool doIntrinsics ) {
		CodeGen::CodeGenerator2 cgv( os );

		for ( std::list<Declaration *>::iterator i = translationUnit.begin(); i != translationUnit.end();  i++ ) {
			if ( LinkageSpec::isGeneratable( (*i)->get_linkage() ) && (doIntrinsics || ! LinkageSpec::isBuiltin( (*i)->get_linkage() ) ) ) {
				(*i)->accept(cgv);
				cgv.shift_left();
				if ( doSemicolon( *i ) ) {
					os << ";";
				} // if
				os << std::endl;
			} // if
		} // for
	}
} // namespace CodeGen

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
