//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// virtual.h -- Builtins for hierarchy objects.
//
// Author           : Andrew Beach
// Created On       : Tus Jul 11 15:08:00 2017
// Last Modified By : Andrew Beach
// Last Modified On : Wed Jul 26 14:18:00 2017
// Update Count     : 1
//

#pragma once

#ifdef __CFORALL__
extern "C" {
#endif

// All strict/explicate vtables should have this head, showing their parent.
struct __cfa__parent_vtable {
    struct __cfa__parent_vtable const * const parent;
};

// Takes in two non-null pointers to type_objects.
int __cfa__is_parent( struct __cfa__parent_vtable const * parent,
		struct __cfa__parent_vtable const * child );

// If parent is a parent of child then return child, otherwise return NULL.
// Input pointers are none-null, child's first level should be an object with
// a vtable
void * __cfa__virtual_cast( struct __cfa__parent_vtable const * parent,
		struct __cfa__parent_vtable const * const * child );

#ifdef __CFORALL__
}
#endif
