//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// utility.h --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Andrew Beach
// Last Modified On : Fri May 5 11:03:00 2017
// Update Count     : 32
//

#ifndef INDENTER_H
#define INDENTER_H

struct Indenter {
	Indenter( unsigned int amt = 2 ) : amt( amt ) {}
	unsigned int amt = 2;  // amount 1 level increases indent by (i.e. how much to increase by in operator++)
	unsigned int indent = 0;

	Indenter & operator+=(int nlevels) { indent += amt*nlevels; return *this; }
	Indenter & operator-=(int nlevels) { indent -= amt*nlevels; return *this; }
	Indenter operator+(int nlevels) { Indenter indenter = *this; return indenter += nlevels; }
	Indenter operator-(int nlevels) { Indenter indenter = *this; return indenter -= nlevels; }
	Indenter & operator++() { return *this += 1; }
	Indenter & operator--() { return *this -= 1; }
};

inline std::ostream & operator<<( std::ostream & out, Indenter & indent ) {
	return out << std::string(indent.indent, ' ');
}

#endif // INDENTER_H
