from __future__ import print_function

import os
import sys
import tools

try :
	sys.path.append(os.getcwd())
	import config

	SRCDIR = os.path.abspath(config.SRCDIR)
	BUILDDIR = os.path.abspath(config.BUILDDIR)
except:
	print('ERROR: missing config.py, re-run configure script.', file=sys.stderr)
	sys.exit(1)

class Architecture:
	KnownArchitectures = {
		'x64'			: 'x64',
		'x86-64'		: 'x64',
		'x86_64'		: 'x64',
		'x86'			: 'x86',
		'i386'		: 'x86',
		'i486'		: 'x86',
		'i686'		: 'x86',
		'Intel 80386'	: 'x86',
		'arm'			: 'arm',
		'ARM'			: 'arm',
	}

	def __init__(self, arch):
		if arch:
			self.cross_compile = True
			try:
				self.target = Architecture.makeCanonical( arch )
			except KeyError:
				print("Unkown architecture %s" % arch)
				sys.exit(1)
		else:
			self.cross_compile = False
			try:
				arch = config.HOSTARCH
				self.target = Architecture.makeCanonical( arch )
			except KeyError:
				print("Running on unkown architecture %s" % arch)
				sys.exit(1)

		self.string = self.target

	def update(self):
		if not self.cross_compile:
			self.target = machine_default()
			self.string = self.target
			print("updated to %s" % self.target)

	def match(self, arch):
		return True if not arch else self.target == arch

	@classmethod
	def makeCanonical(_, arch):
		return Architecture.KnownArchitectures[arch]


class Debug:
	def __init__(self, value):
		self.string = "debug" if value else "no debug"
		self.flags  = """DEBUG_FLAGS="%s" """ % ("-debug" if value else "-nodebug")

class Install:
	def __init__(self, value):
		self.string = "installed" if value else "in-tree"
		self.flags  = """INSTALL_FLAGS="%s" """ % ("" if value else "-in-tree")

def init( options ):
	global arch
	global dry_run
	global generating
	global make
	global debug
	global install

	dry_run    = options.dry_run
	generating = options.regenerate_expected
	make       = 'make'
	debug	     = Debug(options.debug)
	install    = Install(options.install)
	arch       = Architecture(options.arch)


def updateMakeCmd(force, jobs):
	global make

	make = "make" if not force else ("make -j%i" % jobs)

def validate():
	make_ret, _ = tools.make( ".validate", error_file = ".validate.err", redirects  = "2> /dev/null 1> /dev/null", )
	if make_ret != 0:
		with open (".validate.err", "r") as myfile:
			error=myfile.read()
		print('ERROR: Invalid configuration', file=sys.stderr)
		print("       verify returned : \n%s" % error, file=sys.stderr)
		tools.rm("%s/.validate.err" % BUILDDIR)
		sys.exit(1)

	tools.rm("%s/.validate.err" % BUILDDIR)