#include <stdio.h>
#include <ctype.h>

[int, char] most_frequent(const char * str) {
  char freqs [26] = { 0 };
  int ret_freq = 0;
  char ret_ch = 'a';
  for (int i = 0; str[i] != '\0'; ++i) {
    if (isalpha(str[i])) {        // only count letters
      int ch = tolower(str[i]);   // convert to lower case
      int idx = ch-'a';
      if (++freqs[idx] > ret_freq) {  // update on new max
        ret_freq = freqs[idx];
        ret_ch = ch;
      }
    }
  }
  return [ret_freq, ret_ch];
}

void dothing(const char * str) {
  int freq;
  char ch;
  [freq, ch] = most_frequent(str);
  printf("%s -- %d %c\n", str, ret_freq, ret_ch);
}

int main() {
  dothing("hello");
  dothing("hello, world!");
  dothing("aaabbbba");
  dothing("");
}
