#include <stdlib.h>
#include <stdio.h>
#include <unwind.h>

#include "lsda.h"

//Global which defines the current exception
//Currently an int just to make matching easier
int this_exception;

//This is our personality routine
//For every stack frame anotated with ".cfi_personality 0x3,__gcfa_personality_v0"
//This function will be called twice when unwinding
//Once in the search phased and once in the cleanup phase
_Unwind_Reason_Code __gcfa_personality_v0 (
                     int version, _Unwind_Action actions, unsigned long long exceptionClass,
                     struct _Unwind_Exception* unwind_exception, struct _Unwind_Context* context)
{
	//DEBUG
	printf("Personality function (%d, %x, %llu, %p, %p):", version, actions, exceptionClass, unwind_exception, context);

	//If we've reached the end of the stack then there is nothing much we can do...
	if( actions & _UA_END_OF_STACK ) return _URC_END_OF_STACK;
	
	//DEBUG
	if (actions & _UA_SEARCH_PHASE) {
		printf(" lookup phase");
	} 
	//DEBUG
	else if (actions & _UA_CLEANUP_PHASE) {
		printf(" cleanup phase");
	}
	//Just in case, probably can't actually happen
	else {
		printf(" error\n");
		return _URC_FATAL_PHASE1_ERROR;
	}
	
	//Get a pointer to the language specific data from which we will read what we need
	const unsigned char * lsd = (const unsigned char*) _Unwind_GetLanguageSpecificData( context );

	if( !lsd ) {	//Nothing to do, keep unwinding
		printf(" no LSD");
		goto UNWIND;
	}

	//Get the instuction pointer and a reading pointer into the exception table
	lsda_header_info lsd_info;
	const unsigned char * cur_ptr = parse_lsda_header( context, lsd, &lsd_info);
	_Unwind_Ptr instruction_ptr = _Unwind_GetIP( context );

	//Linearly search the table for stuff to do
	while( cur_ptr < lsd_info.action_table ) {
		_Unwind_Ptr callsite_start;
		_Unwind_Ptr callsite_len;
		_Unwind_Ptr callsite_landing_pad;
		_uleb128_t  callsite_action;

		//Decode the common stuff we have in here
		cur_ptr = read_encoded_value (0, lsd_info.call_site_encoding, cur_ptr, &callsite_start);
		cur_ptr = read_encoded_value (0, lsd_info.call_site_encoding, cur_ptr, &callsite_len);
		cur_ptr = read_encoded_value (0, lsd_info.call_site_encoding, cur_ptr, &callsite_landing_pad);
		cur_ptr = read_uleb128 (cur_ptr, &callsite_action);

		//Have we reach the correct frame info yet?
		if( lsd_info.Start + callsite_start + callsite_len < instruction_ptr ) {
			//DEBUG BEGIN
			void * ls = (void*)lsd_info.Start;
			void * cs = (void*)callsite_start;
			void * cl = (void*)callsite_len;
			void * bp = (void*)lsd_info.Start + callsite_start;
			void * ep = (void*)lsd_info.Start + callsite_start + callsite_len;
			void * ip = (void*)instruction_ptr;
			printf("\nfound %p - %p (%p, %p, %p), looking for %p\n", bp, ep, ls, cs, cl, ip);
			//DEBUG END
			continue;
		}
		
		//Have we gone too far
		if( lsd_info.Start + callsite_start > instruction_ptr ) {
			printf(" gone too far");
			break;
		}

		//Something to do?
		if( callsite_landing_pad ) {
			//Which phase are we in
			if (actions & _UA_SEARCH_PHASE) {
				//Search phase, this means we probably found a potential handler and must check if it is a match

				//If we have arbitrarily decided that 0 means nothing to do and 1 means there is a potential handler
				//This doesn't seem to conflict the gcc default behavior
				if (callsite_action != 0) {
					//Now we want to run some code to see if the handler matches
					//This is the tricky part where we want to the power to run arbitrary code
					//However, generating a new exception table entry and try routine every time 
					//is way more expansive than we might like
					//The information we have is :
					//  - The GR (Series of registers)
					//    GR1=GP Global Pointer of frame ref by context
					//  - The instruction pointer
					//  - The instruction pointer info (???)
					//  - The CFA (Canonical Frame Address)
					//  - The BSP (Probably the base stack pointer)


					//The current apprach uses one exception table entry per try block
					_uleb128_t imatcher;
					//Get the relative offset to the 
					cur_ptr = read_uleb128 (cur_ptr, &imatcher);

					//Get a function pointer from the relative offset and call it
					_Unwind_Reason_Code (*matcher)() = (_Unwind_Reason_Code (*)())lsd_info.LPStart + imatcher;					
					_Unwind_Reason_Code ret = matcher();

					//Based on the return value, check if we matched the exception
					if( ret == _URC_HANDLER_FOUND) printf(" handler found\n");
					else printf(" no handler\n");
					return ret;
				}

				//This is only a cleanup handler, ignore it
				printf(" no action");
			} 
			else if (actions & _UA_CLEANUP_PHASE) {

				if( (callsite_action != 0) && !(actions & _UA_HANDLER_FRAME) ){
					//If this is a potential exception handler 
					//but not the one that matched the exception in the seach phase,
					//just ignore it
					goto UNWIND;
				}

				//We need to run some clean-up or a handler
				//These statment do the right thing but I don't know any specifics at all
				_Unwind_SetGR( context, __builtin_eh_return_data_regno(0), (_Unwind_Ptr) unwind_exception );
				_Unwind_SetGR( context, __builtin_eh_return_data_regno(1), 0 );

				//I assume this sets the instruction pointer to the adress of the landing pad
				//It doesn't actually set it, it only state the value that needs to be set once we return _URC_INSTALL_CONTEXT
				_Unwind_SetIP( context, lsd_info.LPStart + callsite_landing_pad );

				//DEBUG
				printf(" action\n");

				//Return have some action to run
				return _URC_INSTALL_CONTEXT;
			}
		}

		//Nothing to do, move along
		printf(" no landing pad");
	}
	//No handling found
	printf(" table end reached\n");

	//DEBUG
	UNWIND:
	printf(" unwind\n");

	//Keep unwinding the stack
	return _URC_CONTINUE_UNWIND;
}

//We need a piece of storage to raise the exception
struct _Unwind_Exception this_exception_storage;

//Function needed by force unwind
//It basically says to unwind the whole stack and then exit when we reach the end of the stack
static _Unwind_Reason_Code _Stop_Fn(	
	int version, 
	_Unwind_Action actions, 
	_Unwind_Exception_Class exceptionClass, 
	struct _Unwind_Exception * unwind_exception, 
	struct _Unwind_Context * context, 
	void * some_param
) {
	if( actions & _UA_END_OF_STACK  ) exit(1);
	if( actions & _UA_CLEANUP_PHASE ) return _URC_NO_REASON;

	return _URC_FATAL_PHASE2_ERROR;
}

//Example throw routine
void throw( int val ) {
	//Store the current exception
	this_exception = val;

	//DEBUG
	printf("Throwing exception %d\n", this_exception);

	//Call stdlibc to raise the exception
	_Unwind_Reason_Code ret = _Unwind_RaiseException( &this_exception_storage );

	//If we reach here it means something happened
	//For resumption to work we need to find a way to return back to here
	//Most of them will probably boil down to setting a global flag and making the phase 1 either stop or fail.
	//Causing an error on purpose may help avoiding unnecessary work but it might have some weird side effects.
	//If we just pretend no handler was found that would work but may be expensive for no reason since we will always
	//search the whole stack

	if( ret == _URC_END_OF_STACK ) {
		//No proper handler was found
		//This can be handled in several way
		//C++ calls std::terminate
		//Here we force unwind the stack, basically raising a cancellation
		printf("Uncaught exception %p\n", &this_exception_storage);
		
		ret = _Unwind_ForcedUnwind( &this_exception_storage, _Stop_Fn, (void*)0x22 );
		printf("UNWIND ERROR %d after force unwind\n", ret);
		abort();
	}

	//We did not simply reach the end of the stack without finding a handler,
	//Something wen't wrong
	printf("UNWIND ERROR %d after raise exception\n", ret);
	abort();
}
