#include <algorithm>
#include <fstream>
#include "bench.hpp"
#include "cpp-vstack.hpp"
#include "cpp-vprint.hpp"
#include "object.hpp"

int main(int argc, char** argv) {
	std::ofstream out{"cpp-vout.txt"};
	integer max{ 0 };
	stack s, t;
	
	REPEAT_TIMED( "push_int", s.push( make<integer>( _i ) ); )
	TIMED( "copy_int", t = s; )
	TIMED( "clear_int", s.clear(); )
	REPEAT_TIMED( "pop_int", max = std::max( max, t.pop()->as<integer>() ); /***/ )
	print( out, max, c_string{"\n"} );
	REPEAT_N_TIMED( "print_int", N/2, 
		print( out, integer{_i}, c_string{":"}, integer{_i}, c_string{"\n"} ); )

	ptr<pair> max1 = make<pair>( make<boolean>(false), make<character>('\0') );
	stack s1, t1;
	
	REPEAT_TIMED( "push_bool_char", 
		s1.push( make<pair>( make<boolean>(_i & 1), make<character>(_i & 0x7F) ) ); )
	TIMED( "copy_bool_char", t1 = s1; )
	TIMED( "clear_bool_char", s1.clear(); )
	REPEAT_TIMED( "pop_bool_char",
		ptr<pair> x = as_ptr<pair>( t1.pop() ); /***/
		if ( *x > *max1 ) { max1 = std::move(x); } )
	print( out, *max1, c_string{"\n"} );
	REPEAT_N_TIMED( "print_pair", N/2, 
		print( out, pair{ make<boolean>(_i & 1), make<character>(_i & 0x7F) }, c_string{":"}, 
			pair{ make<boolean>(_i & 1), make<character>(_i & 0x7F) }, c_string{"\n"} ); )
}
