#include <stdio.h>
#include <stdlib.h>
#include "bench.h"
#include "c-pair.h"
#include "c-stack.h"
#include "c-print.h"

_Bool* new_bool( _Bool b ) {
	_Bool* q = malloc(sizeof(_Bool)); /***/
	*q = b;
	return q;
}

char* new_char( char c ) {
	char* q = malloc(sizeof(char)); /***/
	*q = c;
	return q;
}

int* new_int( int i ) {
	int* q = malloc(sizeof(int)); /***/
	*q = i;
	return q;
}

void* copy_bool( const void* p ) { return new_bool( *(const _Bool*)p ); } /***/
void* copy_char( const void* p ) { return new_char( *(const char*)p ); } /***/
void* copy_int( const void* p ) { return new_int( *(const int*)p ); } /***/
void* copy_pair_bool_char( const void* p ) { return copy_pair( p, copy_bool, copy_char ); } /***/
void free_pair_bool_char( void* p ) { free_pair( p, free, free ); } /***/

int cmp_bool( const void* a, const void* b ) { /***/
	return *(const _Bool*)a == *(const _Bool*)b ? 0 : *(const _Bool*)a < *(const _Bool*)b ? -1 : 1; 
}

int cmp_char( const void* a, const void* b ) {
	return *(const char*)a == *(const char*)b ? 0 : *(const char*)a < *(const char*)b ? -1 : 1; /***/
}

int main(int argc, char** argv) {
	FILE* out = fopen("c-out.txt", "w");
	int max = 0;
	struct stack s = new_stack(), t;
	REPEAT_TIMED( "push_int", push_stack(&s, new_int( _i )); )
	TIMED( "copy_int", 	copy_stack(&t, &s, copy_int); /***/ )
	TIMED( "clear_int", clear_stack(&s, free); /***/ )
	REPEAT_TIMED( "pop_int", 
		int* x = pop_stack(&t); /***/
		if ( *x > max ) { max = *x; }
		free(x); )
	REPEAT_N_TIMED( "print_int", N/2, print( out, "dsds", _i, ":", _i, "\n" ); /***/ )

	struct pair* max2 = new_pair( new_bool(0), new_char('\0') );
	struct stack s2 = new_stack(), t2;

	REPEAT_TIMED( "push_bool_char", 
		push_stack(&s2, new_pair( new_bool( _i & 0x1 ), new_char( _i & 0x7F ) )); )
	TIMED( "copy_bool_char", copy_stack(&t2, &s2, copy_pair_bool_char); /***/ )
	TIMED( "clear_bool_char", clear_stack(&s2, free_pair_bool_char); /***/ )
	REPEAT_TIMED( "pop_bool_char", 
		struct pair* x = pop_stack(&t2); /***/
		if ( cmp_pair( x, max2, cmp_bool, cmp_char ) > 0 ) { /***/
			free_pair_bool_char( max2 ); /***/
			max2 = x;
		} else {
			free_pair_bool_char( x ); /***/
		} )
	REPEAT_N_TIMED( "print_pair", N/2, 
		struct pair p1 = ((struct pair){ new_bool(rand() & 0x1), new_char(rand() & 0x7F) }); /***/
		struct pair p2 = ((struct pair){ new_bool(rand() & 0x1), new_char(rand() & 0x7F) }); /***/
		print( out, "pbcspbcs", p1, ":", p2, "\n" ); /***/
		free(p1.first); free(p1.second); /***/
		free(p2.first); free(p2.second); /***/ )
	free_pair_bool_char( max2 ); /***/
	fclose(out);
}
