//                              -*- Mode: C -*-
//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// invoke.h --
//
// Author           : Thierry Delisle
// Created On       : Tue Jan 17 12:27:26 2016
// Last Modified By : Thierry Delisle
// Last Modified On : --
// Update Count     : 0
//

#include <stdbool.h>
#include <stdint.h>

#ifdef __CFORALL__
extern "C" {
#endif

#if ! defined(__CFA_INVOKE_PRIVATE__)
#ifndef _INVOKE_H_
#define _INVOKE_H_

      #define unlikely(x)    __builtin_expect(!!(x), 0)
      #define thread_local _Thread_local
      #define SCHEDULER_CAPACITY 10

      struct simple_thread_list {
            struct thread * head;
            struct thread ** tail;
      };

      #ifdef __CFORALL__
      extern "Cforall" {
            void ?{}( struct simple_thread_list * );
            void append( struct simple_thread_list *, struct thread * );
            struct thread * pop_head( struct simple_thread_list * );
      }
      #endif

      struct coStack_t {
            unsigned int size;		// size of stack
            void *storage;			// pointer to stack
            void *limit;			// stack grows towards stack limit
            void *base;				// base of stack
            void *context;			// address of cfa_context_t
            void *top;				// address of top of storage
            bool userStack;	
      };

      enum coroutine_state { Start, Inactive, Active, Halt, Primed };

      struct coroutine {
            struct coStack_t stack;
            const char *name;			// textual name for coroutine/task, initialized by uC++ generated code
            int errno_;				// copy of global UNIX variable errno
            enum coroutine_state state;	// current execution status for coroutine
            bool notHalted;			// indicate if execuation state is not halted

            struct coroutine *starter;	// first coroutine to resume this one
            struct coroutine *last;		// last coroutine to resume this one
      };

      struct simple_lock {
      	struct simple_thread_list blocked;
      };

      struct thread {
            struct coroutine c;
            struct simple_lock lock;
            struct thread * next;
      };

#endif //_INVOKE_H_
#else //! defined(__CFA_INVOKE_PRIVATE__)
#ifndef _INVOKE_PRIVATE_H_
#define _INVOKE_PRIVATE_H_
      
      struct machine_context_t {
            void *SP;
            void *FP;
            void *PC;
      };

      // assembler routines that performs the context switch
      extern void CtxInvokeStub( void );
      void CtxSwitch( void * from, void * to ) asm ("CtxSwitch");
      void CtxGet( void * this ) asm ("CtxGet");

#endif //_INVOKE_PRIVATE_H_
#endif //! defined(__CFA_INVOKE_PRIVATE__)
#ifdef __CFORALL__
}
#endif
