// 
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// as.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Aug  1 10:49:42 2018
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug  2 12:06:23 2018
// Update Count     : 78
// 

#include <iostream>
#include <fstream>
using namespace std;
#include <cstdio>										// perror
#include <cstdlib>										// exit, mkstemps
#include <unistd.h>										// execvp, unlink
#include <csignal>										// signal

//#define __DEBUG_H__


#define SUFFIX ".s"
char tmpname[] = P_tmpdir "/CFAXXXXXX" SUFFIX;
int tmpfilefd = -1;


void rmfile( const char * fname ) {
	if ( unlink( fname ) == -1 ) {						// remove tmpname
		perror ( "CFA Translator error: cpp failed" );
		exit( EXIT_FAILURE );
	} // if
} // rmtmpfile


void sigTermHandler( __attribute__((unused)) int signal ) {
	if ( tmpfilefd != -1 ) {							// RACE, file created ?
		rmfile( tmpname );								// remove
		exit( EXIT_FAILURE );							// terminate 
	} // if
	tmpfilefd = -1;										// mark closed
} // sigTermHandler


int main( const int argc, const char * argv[], __attribute__((unused)) const char * const env[] ) {
	#ifdef __DEBUG_H__
	for ( int i = 0; env[i] != NULL; i += 1 ) {
		cerr << env[i] << endl;
	} // for

	for ( int i = 0; i < argc; i += 1 ) {
		cerr << argv[i] << endl;
	} // for
	#endif // __DEBUG_H__

	signal( SIGINT,  sigTermHandler );					// try to delete temporary file on interrupt
	signal( SIGTERM, sigTermHandler );

	// Create a temporary file to store output of the modified assembler.

	tmpfilefd = mkstemps( tmpname, sizeof( SUFFIX ) - 1 );
	if ( tmpfilefd == -1 ) {
		perror( "CFA Translator error: cpp level, mkstemp" );
		exit( EXIT_FAILURE );
	} // if
	FILE * tmpfilest = fdopen( tmpfilefd, "w" );		// wrap C stream (cannot wrap C++ stream)

	#ifdef __DEBUG_H__
	cerr << "tmpname:" << tmpname << " tmpfilefd:" << tmpfilefd << endl;
	#endif // __DEBUG_H__

	ifstream in;
	in.exceptions( ios_base::failbit );					// use exceptions versus return codes
	try {
		in.open( argv[argc - 1] );						// assume .s file is last argument
	} catch( ios_base::failure ) {
		perror ( "CFA Translator error: cpp failed" );
		exit( EXIT_FAILURE );
	} // try

	try {
		string line;
		for ( ;; ) {									// loop until end-of-file
			getline( in, line );
			line += '\n';
			fprintf( tmpfilest, "%s", line.c_str() );
			if ( line == ".Ldebug_info0:\n" ) {			// debug information ?
				for ( int i = 0; i < 6; i += 1 ) {		// move 6 lines forward
					getline( in, line );
					line += '\n';
					fprintf( tmpfilest, "%s", line.c_str() );
				} // for
				getline( in, line );					// ignore C language line
				fprintf( tmpfilest, "%s", "\t.byte\t0x25\n" ); // replace with CFA language line
			} // if
		} // for
	} catch ( ios_base::failure ) {
		fclose( tmpfilest );							// flush buffers
	} // try

	rmfile( argv[argc - 1] );							// remove given file

	if ( rename( tmpname, argv[argc - 1] ) == -1 ) {	// rename temp file to original file
		perror ( "CFA Translator error: cpp failed" );
		exit( EXIT_FAILURE );
	} // if

	argv[0] = "as";
	execvp( argv[0], (char * const *)argv );			// should not return
	perror( "CFA Translator error: cpp level, execvp" );
	exit( EXIT_FAILURE );								// tell gcc not to go any further
} // main

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "g++ -Wall -Wextra as.c -o as" //
// End: //
