#pragma once

#include <stddef.h>
#include <stdint.h>

#include "tools.h"

struct gc_state
{
	bool is_initialized;
	uint8_t from_code;
	struct gc_memory_pool* to_space;
	struct gc_memory_pool* from_space;

	size_t total_space;
	size_t used_space;

	const struct memory_pool* 	pools_table;
	size_t 				pools_table_count;
};

void gc_state_ctor(gc_state* state);

inline gc_state* get_state()
{
	static gc_state s;
	if(!s.is_initialized) gc_state_ctor(s);
	return &s;
}

inline bool needs_collect(gc_state* state)
{
	return state->used_space * 2 > state->total_space;
}

void gc_collect(gc_state* state);

void* gc_try_allocate(gc_state* state, size_t size);

void gc_allocate_pool(gc_state* state);

bool gc_is_in_heap(const gc_state* state, void* address);

bool gc_is_in_to_space(const gc_state* state, void* address);

inline uint8_t gc_from_space_code(const gc_state* state)
{
	return state->from_code;
}

struct gc_object_header* gc_get_object_for_ref(gc_state* state, void*);

inline void gc_register_allocation(gc_state* state, size_t size)
{
	state->used_space += size;
}
