#!lua

-- Additional Linux libs: "X11", "Xxf86vm", "Xi", "Xrandr", "stdc++"

includeDirList = {
	"src/",
	"../",
}

libDirectories = {

}


if os.get() == "linux" then
    linkLibs = {

    }
end

-- Build Options:
buildOptions = {""}

solution "GC-no-RAII"
	configurations  { "debug", "release",
				"cproc-debug", "cproc-release",
				"cfa-debug", "cfa-release" }

	project "gc-test"
		kind "ConsoleApp"
		language "C"
		location "build"
		objdir "build"
		targetdir "."
		buildoptions (buildOptions)
		libdirs (libDirectories)
		links (linkLibs)
		linkoptions (linkOptionList)
		includedirs (includeDirList)
		files { "../fstream.c", "../iostream.c", "../iterator.c", "src/*.c" }

	configuration "debug"
		defines { "DEBUG", "bool=_Bool" }
		flags { "Symbols" }

	configuration "release"
		defines { "NDEBUG", "bool=_Bool" }
		flags { "Optimize" }

	configuration "cproc-debug"
		buildoptions ({"-E"})
		linkoptions ({"-E"})
	      defines { "DEBUG", "bool=_Bool" }
	      flags { "Symbols" }

	configuration "cproc-release"
		buildoptions ({"-E"})
		linkoptions ({"-E"})
	      defines { "DEBUG", "bool=_Bool" }
	      flags { "Symbols" }

	configuration "cfa-debug"
		linkoptions ({"-E"})
		files { "build/cproc-debug/*.o" }
	      defines { "DEBUG", "bool=_Bool" }
	      flags { "Symbols" }

	configuration "cfa-release"
		linkoptions ({"-E"})
		files { "build/cproc-debug/*.o" }
	      defines { "DEBUG", "bool=_Bool" }
	      flags { "Symbols" }
