# set terminal pdfcairo linewidth 3 size 6,3
# set output "timing.pdf"
set terminal pslatex size 6.25,2.125 color solid
set output BUILD."generic-timing.tex"

set pointsize 2.0
set grid linetype 0
set style data histogram
set style histogram cluster gap 2
set style fill solid border -1
set offset -0.5,-0.35
set boxwidth 0.8

set key top left reverse Left

set style fill solid noborder
set linetype 1 lc rgb 'black'
set linetype 2 lc rgb 'red'
set linetype 3 lc rgb 'blue'
set linetype 4 lc rgb 'green'

SCALE=1000
set ylabel "seconds"
set yrange [0:10]

set label "23.9" at 7.125,10.5
set style fill pattern 4 border lt -1
# set datafile separator ","
plot for [COL=2:5] 'evaluation/generic-timing.dat' using (column(COL)/SCALE):xticlabels(1) title columnheader
