// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// io.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Mar  2 16:56:02 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Jul  6 23:26:12 2017
// Update Count     : 78
// 

#include <fstream>

int main() {
	char c;												// basic types
	short int si;
	unsigned short int usi;
	int i;
	unsigned int ui;
	long int li;
	unsigned long int uli;
	long long int lli;
	unsigned long long int ulli;
	float f;
	double d;
	long double ld;
	float _Complex fc;
	double _Complex dc;
	long double _Complex ldc;
	enum { size = 10 };
	char s1[size], s2[size];

	int x = 3, y = 5, z = 7;
	sout | x * 3 | y + 1 | z << 2 | x == y | (x | y) | (x || y) | (x > z ? 1 : 2) | endl;
	sout | 1 | 2 | 3 | endl;
	sout | '1' | '2' | '3' | endl;
	sout | 1 | "" | 2 | "" | 3 | endl;
	sout | endl;

	sout | "opening delimiters" | endl;
	sout
		| "x (" | 1
		| "x [" | 2
		| "x {" | 3
		| "x =" | 4
		| "x $" | 5
		| "x " | 6
		| "x " | 7
		| "x " | 8
		| "x " | 9
		| "x " | 10
		| endl | endl;

	sout | "closing delimiters" | endl;
	sout
		| 1 | ", x"
		| 2 | ". x"
		| 3 | "; x"
		| 4 | "! x"
		| 5 | "? x"
		| 6 | "% x"
		| 7 | " x"
		| 8 | " x"
		| 9 | ") x"
		| 10 | "] x"
		| 11 | "} x"
		| endl | endl;

	sout | "opening/closing delimiters" | endl;
	sout
		| "x`" | 1 | "`x'" | 2
		| "'x\"" | 3 | "\"x:" | 4
		| ":x " | 5 | " x\t" | 6
		| "\tx\f" | 7 | "\fx\v" | 8
		| "\vx\n" | 9 | "\nx\r" | 10
		| "\rx"
		| endl | endl;

	sout | "override opening/closing delimiters" | endl;
	sout | "x ( " | 1 | " ) x" | 2 | " , x" | 3 | " :x: " | 4 | endl;
	sout | endl;

	ifstream in;										// create / open file
	open( &in, "io.data", "r" );

	sout | "input bacis types" | endl;
	&in | &c											// character
		| &si | &usi | &i | &ui | &li | &uli | &lli | &ulli	// integral
		| &f | &d | &ld									// floating point
		| &fc | &dc | &ldc								// floating-point complex
		| cstr( s1 ) | cstr( s2, size );				// C string, length unchecked and checked
	sout | endl;

	sout | "output basic types" | endl;
	sout | c | ' ' | endl								// character
		| si | usi | i | ui | li | uli | lli | ulli | endl // integral
		| f | d | ld | endl								// floating point
		| fc | dc | ldc | endl;							// complex
	sout | endl;

	sout | "tuples" | endl;
	[int, [ int, int ] ] t1 = [ 1, [ 2, 3 ] ], t2 = [ 4, [ 5, 6 ] ];
	sout | t1 | t2 | endl;								// print tuple
	sout | endl;

	sout | "toggle separator" | endl;
	sout | f | "" | d | "" | ld | endl					// floating point without separator
		| sepDisable | fc | dc | ldc | endl				// complex without separator
		| fc | sepOn | dc | ldc | endl					// local separator add
		| sepEnable | fc | dc | ldc | endl				// complex with separator
		| fc | sepOff | dc | ldc | endl					// local separator removal
		| s1 | sepOff | s2 | endl						// local separator removal
		| s1 | "" | s2 | endl;							// local separator removal
	sout | endl;

	sout | "change separator" | endl;
	sout | "from \"" | sep | "\"";
	sepSet( sout, ", $" );								// change separator, maximum of 15 characters
	sout | " to \"" | sep | "\"" | endl;
	sout | f | d | ld | endl
		| fc | dc | ldc | endl
		| s1 | s2 | endl
		| t1 | t2 | endl;								// print tuple
	sout | endl;
	sout | "from \"" | sep | "\" ";
	sepSet( sout, " " );								// restore separator
	sout | "to \"" | sep | "\"" | endl;
	sout | f | d | ld | endl
		| fc | dc | ldc | endl
		| s1 | s2 | endl
		| t1 | t2 | endl;								// print tuple
	sout | endl;

	sout | "check sepOn/sepOff" | endl;
	sout | sepOn | 1 | 2 | 3 | sepOn | endl;			// no separator at start/end of line
	sout | 1 | sepOff | 2 | 3 | endl;					// locally turn off implicit separator
	sout | sepOn | sepOn | 1 | 2 | 3 | sepOn | sepOff | sepOn | '\n'; // no separator at start/end of line
	sout | 1 | 2 | 3 | "\n\n" | sepOn;					// no separator at start of next line
	sout | 1 | 2 | 3 | endl;
	sout | endl;

	sout | "check enable/disable" | endl;
	sout | sepDisable | 1 | 2 | 3 | endl;				// globally turn off implicit separation
	sout | 1 | sepOn | 2 | 3 | endl;					// locally turn on implicit separator
	sout | sepEnable | 1 | 2 | 3 | endl | sepDisable;	// globally turn on/off implicit separation
	sout | 1 | 2 | 3 | endl | sepEnable;				// globally turn on implicit separation
	sout | 1 | 2 | 3 | sepOn | sepDisable | endl;		// ignore seperate at end of line
	sout | 1 | 2 | 3 | sepOn | sepEnable | endl;		// separator at end of line
	sout | 1 | 2 | 3 | endl;
	sout | endl;

//	sout | fmt( d, "%8.3f" ) || endl;
//	sout | endl;

	sepSetTuple( sout, " " );							// set tuple separator from ", " to " "
	sout | t1 | t2 | " \"" | sep | "\"" | endl;
	sepSetTuple( sout, ", " );							// reset tuple separator to ", "
	sout | t1 | t2 | " \"" | sep | "\"" | endl;
	sout | t1 | t2 | endl;								// print tuple
	sout | endl;

	[int, int, const char *, double] t3 = { 3, 4, "a", 7.2 };
	sout | [ 3, 4, "a", 7.2 ] | endl;
	sout | t3 | endl;
	sepSetTuple( sout, " " );
	sout | t3 | endl;
	sout | sepOn | t3 | sepDisable | t3 | sepEnable | t3 | endl;
	sepSet( sout, "^" );
	sepSetTuple( sout, "-" );
	sout | t3 | 3 | 4 | t3 | endl;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa io.c" //
// End: //
