//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// PolyCost.cc --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 09:50:12 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 17 09:52:02 2015
// Update Count     : 3
//

#include "Common/PassVisitor.h"
#include "SymTab/Indexer.h"   // for Indexer
#include "SynTree/Type.h"     // for TypeInstType, Type
#include "TypeEnvironment.h"  // for EqvClass, TypeEnvironment

namespace ResolvExpr {
	struct PolyCost {
		PolyCost( const TypeEnvironment &env, const SymTab::Indexer &indexer );

		void previsit( TypeInstType * aggregateUseType );
		int result;
		const TypeEnvironment &tenv;
		const SymTab::Indexer &indexer;
	};

	int polyCost( Type *type, const TypeEnvironment & env, const SymTab::Indexer &indexer ) {
		PassVisitor<PolyCost> coster( env, indexer );
		type->accept( coster );
		return coster.pass.result;
	}

	PolyCost::PolyCost( const TypeEnvironment & env, const SymTab::Indexer & indexer ) : result( 0 ), tenv( env ), indexer( indexer ) {
	}

	void PolyCost::previsit(TypeInstType * typeInst) {
		EqvClass eqvClass;
		if ( tenv.lookup( typeInst->name, eqvClass ) ) {
			if ( eqvClass.type ) {
				if ( TypeInstType * otherTypeInst = dynamic_cast< TypeInstType* >( eqvClass.type ) ) {
					if ( indexer.lookupType( otherTypeInst->name ) ) {
						// bound to opaque type
						result += 1;
					} // if
				} else {
					// bound to concrete type
					result += 1;
				} // if
			} // if
		} // if
	}

} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
