//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// CurrentObject.h --
//
// Author           : Rob Schluntz
// Created On       : Thu Jun  8 11:07:25 2017
// Last Modified By : Rob Schluntz
// Last Modified On : Thu Jun  8 11:07:41 2017
// Update Count     : 2
//

#ifndef CURRENT_OBJECT_H
#define CURRENT_OBJECT_H

#include <stack>

#include "SynTree/SynTree.h"
#include "SynTree/Expression.h"

namespace ResolvExpr {
	class MemberIterator;

	class CurrentObject {
	public:
		CurrentObject();
		CurrentObject( Type * type );

		/// resolves unresolved designation
		Designation * findNext( Designation * designation );
		/// sets current position using resolved designation
		void setNext( Designation * designation );
		/// steps to next sub-object of current-object
		void increment();
		/// sets new current-object for the duration of this brace-enclosed initializer-list
		void enterListInit();
		/// restores previous current-object
		void exitListInit();
		/// produces a list of alternatives (Type *, Designation *) for the current sub-object's initializer
		std::list< InitAlternative > getOptions();
		/// produces the type of the current object but no subobjects
		Type * getCurrentType();

	private:
		std::stack< MemberIterator * > objStack;
	};
} // namespace ResolvExpr

#endif // CURRENT_OBJECT_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //

