//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Resolver.h --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 12:18:34 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:36:57 2017
// Update Count     : 3
//

#pragma once

#include <list>  // for list

class ConstructorInit;
class Declaration;
class Expression;
class StmtExpr;
namespace SymTab {
class Indexer;
}  // namespace SymTab

namespace ResolvExpr {
	/// Checks types and binds syntactic constructs to typed representations
	void resolve( std::list< Declaration * > translationUnit );
	void resolveDecl( Declaration *, const SymTab::Indexer &indexer );
	Expression *resolveInVoidContext( Expression *expr, const SymTab::Indexer &indexer );
	Expression *findVoidExpression( Expression *untyped, const SymTab::Indexer &indexer );
	Expression * findSingleExpression( Expression *untyped, const SymTab::Indexer &indexer );
	void resolveCtorInit( ConstructorInit * ctorInit, const SymTab::Indexer & indexer );
	void resolveStmtExpr( StmtExpr * stmtExpr, const SymTab::Indexer & indexer );
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
