def Prod( N ):
	cons = yield				# get cons
	yield						# resume scheduler
	for i in range( N ):
		print( "prod" )
		yield cons				# execute next
	print( "end", "prod" )

def Cons( N ):
	prod = yield				# get prod
	yield						# resume scheduler
	for i in range( N ):
		print( "cons" )
		yield prod				# execute next
	print( "end", "cons" )

def Scheduler():
	n = yield					# starting coroutine
	try:
		while True:
			n = next( n )		# schedule coroutine
	except StopIteration:
		pass

prod = Prod( 5 )
cons = Cons( 5 )
next( prod )					# prime
prod.send( cons )				# send cons
next( cons )					# prime
cons.send( prod )				# send prod

s = Scheduler();
next( s )						# prime
try:
	s.send( prod )				# start cycle
except StopIteration:			# scheduler stopped
	pass
print( "stop" )

# Local Variables: #
# tab-width: 4 #
# compile-command: "python3.7 ProdCons.py" #
# End: #
