//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// OperatorTable.h --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Jul 21 22:17:11 2017
// Update Count     : 6
//

#pragma once

#include <string>

namespace CodeGen {
	enum OperatorType {
		OT_INDEX,
		OT_CTOR,
		OT_DTOR,
		OT_CALL,
		OT_PREFIX,
		OT_POSTFIX,
		OT_INFIX,
		OT_PREFIXASSIGN,
		OT_POSTFIXASSIGN,
		OT_INFIXASSIGN,
		OT_LABELADDRESS,
		OT_CONSTANT
	};

	struct OperatorInfo {
		std::string inputName;
		std::string symbol;
		std::string outputName;
		OperatorType type;
	};

	bool operatorLookup( std::string funcName, OperatorInfo &info );

	bool isConstructor( const std::string & );
	bool isDestructor( const std::string & );
	bool isAssignment( const std::string & );
	bool isCtorDtor( const std::string & );
	bool isCtorDtorAssign( const std::string & );
} // namespace CodeGen

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
