#pragma once

#include <stdlib>

typedef char char_t;

//######################### HandleNode #########################
struct VbyteHeap_t;

struct HandleNode_t
{
	char_t* string;
	unsigned short int length;

	HandleNode_t* next;
	HandleNode_t* previous;
};

void DeleteNode(HandleNode_t* const this);
void AddThisAfter(HandleNode_t* const this, HandleNode_t* other);

void MoveThisAfter(HandleNode_t* const this, const HandleNode_t* rhs);
void MoveThisBefore(HandleNode_t* const this, const HandleNode_t* rhs);

//######################### VbyteHeap #########################
struct VbyteHeap
{
	int NoOfCompactions;
	int NoOfExtensions;
	int NoOfReductions;

	int InitSize;
	int CurrSize;
	char_t* StartVbyte;
	char_t* EndVbyte;
	void* ExtVbyte;

	HandleNode_t Header;
};

void compaction(VbyteHeap* const this);
void garbage(VbyteHeap* const this);
void extend(VbyteHeap* const this, int);
void reduce(VbyteHeap* const this, int);

//######################### HandleNode #########################
static inline ctor(HandleNode_t* const this)
{
	this->string = (void*)0;
	this->length = 0;
}

static inline ctor(HandleNode_t* const this, VbyteHeap* vh)
{
	this->string = (void*)0;
	this->length = 0;
	HandleNode_t* const node = &vh->Header;
	AddThisAfter(this, node->previous);
}

static inline dtor(HandleNode_t* const this)
{
	DeleteNode(this);
}

//######################### VbyteHeap #########################
static inline ctor(VbyteHeap* const this, int size)
{
	this->NoOfCompactions = 0;
	this->NoOfExtensions = 0;
	this->NoOfReductions = 0;

	this->InitSize = size;
	this->CurrSize = size;

	this->StartVbyte = calloc(size);
	this->EndVbyte = this->StartVbyte;
	this->ExtVbyte = (void*)( this->StartVbyte + this->CurrSize );

	ctor((HandleNode_t* const)&this->Header);
	this->Header.next = &this->Header;
	this->Header.previous = &this->Header;
}

static inline dtor(VbyteHeap* const this)
{
	free(this->StartVbyte);
}
