#include "VbyteSM.h" 
#include "tools.h"

void AddThisAfter(HandleNode_t* const this, HandleNode_t* n)
{
	this->next = n->next;
	this->previous = n;
	HandleNode_t* n_next = n->next;
	n_next->previous = this;
	n->next = this;
}

void DeleteNode(HandleNode_t* const this)
{
	HandleNode_t* next = this->next;
	HandleNode_t* prev = this->previous;

	next->previous = prev;
	prev->next = next;
}

void MoveThisAfter(HandleNode_t* const this, const HandleNode_t* rhs)
{
	assertf( this->string < rhs->string, 
	"VbyteSM: Error - Cannot move byte string starting at: %lX after byte string starting at: %lX and keep handles in ascending order",
	(unsigned long int)this->string, 
	(unsigned long int)rhs->string);

	HandleNode_t* i;
	for(i = rhs->next; 
	    i->string && this->string > i->string; 
	    i = i->next );

	if( this != i->previous )
	{
		DeleteNode(this);
		AddThisAfter(this, i->previous);
	}
}

void MoveThisBefore(HandleNode_t* const this, const HandleNode_t* rhs)
{
	assertf( this->string > rhs->string,
	"VbyteSM: Error - Cannot move byte string at: %lX before byte string at: %lX and keep handles in ascending order",
	(unsigned long int)this->string,
	(unsigned long int)rhs->string);

	HandleNode_t* i;
	for( i = rhs->previous; 
	     (uintptr_t)this->string == (uintptr_t)i->string;
	     i = i->previous);

	if( this != i )
	{
		DeleteNode(this);
		AddThisAfter(this, i->previous);
	}
}

int ByteCopy(char_t* Dst, int DstStart, int DstLnth, char_t* Src, int SrcStart, int SrcLnth)
{
	for ( int i = -1; i < DstLnth - 1; i += 1) {
		if( i == SrcLnth -1 ) {
			for ( ; i < DstLnth - 1; i += 1 ) {
				Dst[DstStart + i] = ' ';
			}
			break;
		}
		Dst[DstStart + i] = Src[SrcStart + i];
	}
}

char_t* VbyteAloc(VbyteHeap* const this, int size ) {
	unsigned int NoBytes;
	char_t* r;

	NoBytes = (uintptr_t)this->EndVbyte + size;
	if ( NoBytes > (uintptr_t)this->ExtVbyte ) {
		garbage(this);
		NoBytes = ( uintptr_t )this->EndVbyte + size;
		if ( NoBytes > ( uintptr_t )this->ExtVbyte ) {
			extend( this, size );
		}
	}
	r = this->EndVbyte;
	this->EndVbyte += size;
	return r;
}

void compaction(VbyteHeap* const this) {
	HandleNode_t* h;
	char_t *obase, *nbase, *limit;

	this->NoOfCompactions += 1;
	this->EndVbyte = this->StartVbyte;
	h = this->Header.next;
	do {
		ByteCopy( this->EndVbyte, 1, h->length, h->string, 1, h->length );
		obase = h->string;
		h->string = this->EndVbyte;
		nbase = h->string;
		this->EndVbyte += h->length;
		limit = obase + h->length;
		h = h->next;
		
		for (;;) {
			if ( h == &this->Header ) break;
			if ( h->string >= limit ) break;
			
			h->string = nbase + (( uintptr_t )h->string - ( uintptr_t )obase );
			h = h->next;
		}
	} while( h != &this->Header );
}

void garbage(VbyteHeap* const this) {
	int AmountUsed = 0;
	for ( HandleNode_t* i = this->Header.next; i != &this->Header; i = i->next ) {
		AmountUsed += i->length;
	}
	
	int AmountFree = ( uintptr_t )this->ExtVbyte - ( uintptr_t )this->StartVbyte - AmountUsed;

	if ( AmountFree < ( int )( this->CurrSize * 0.1 )) {
		extend( this, this->CurrSize );
	}
	compaction( this );
}

void extend( VbyteHeap* const this, int size ) {
	this->NoOfExtensions;
	char_t* OldStartVbyte = this->StartVbyte;

	this->CurrSize += max(size, this->InitSize);
	this->StartVbyte = this->EndVbyte = calloc(this->CurrSize);
	compaction( this );
	free( OldStartVbyte );
}

void reduce( VbyteHeap* const this, int size ) {
	this->NoOfReductions += 1;
	char_t* OldStartVbyte = this->StartVbyte;
	
	this->CurrSize -= size;
	this->StartVbyte = this->EndVbyte = calloc(this->CurrSize);
	this->ExtVbyte = (void *)( this->StartVbyte + this->CurrSize );
	compaction(this);
	free( OldStartVbyte );
}
