//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FixGlobalInit.h --
//
// Author           : Rob Schluntz
// Created On       : Mon May 04 15:14:56 2016
// Last Modified By : Rob Schluntz
// Last Modified On : Fri May 06 16:07:47 2016
// Update Count     : 2
//

#ifndef FIX_GLOBAL_INIT_H
#define FIX_GLOBAL_INIT_H

#include <string>
#include <list>

#include "SynTree/SynTree.h"
#include "SynTree/Declaration.h"

namespace InitTweak {
  /// Moves global initialization into an _init function that is unique to the translation unit.
  /// Sets the priority of the initialization function depending on whether the initialization
  /// function is for library code.
  void fixGlobalInit( std::list< Declaration * > & translationUnit, const std::string & name, bool inLibrary );

  /// Apply transformations to a file name to get a valid C identifier which will be used as
  /// the name of the generated initializer function.
  std::string globalFunctionName( const std::string & name );
} // namespace

#endif // GENPOLY_POLYMUTATOR_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
