#pragma once

#if defined(__cforall)
extern "C" {
#endif
	#include <stdlib.h>
	#include <unistd.h>					// sysconf
#if ! defined(__cforall)
	#include <time.h>
	#include <sys/time.h>
#else
}
#include <time>
#endif


static inline unsigned long long int bench_time() {
    struct timespec ts;
    clock_gettime(
#if defined( __linux__ )
	 CLOCK_THREAD_CPUTIME_ID,
#elif defined( __freebsd__ )
	 CLOCK_PROF,
#elif defined( __solaris__ )
	 CLOCK_HIGHRES,
#else
    #error uC++ : internal error, unsupported architecture
#endif
	 &ts );
    return 1000000000LL * ts.tv_sec + ts.tv_nsec;
} // Time

#ifndef BENCH_N
#define BENCH_N 500 //10000000
#endif

#define BENCH(statement, output)		\
	size_t n = BENCH_N;			\
	if( argc > 2 ) return 1;		\
	if( argc == 2 ) {				\
		n = atoi(argv[1]);		\
	}						\
	long long int StartTime, EndTime;	\
	StartTime = bench_time();		\
	statement;					\
	EndTime = bench_time();			\
	unsigned long long int output = 	\
	( EndTime - StartTime ) / n;

#if defined(__cforall)
Duration default_preemption() {
	return 0;
}
#endif
