//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Print.hpp --
//
// Author           : Thierry Delisle
// Created On       : Tue May 21 16:20:15 2019
// Last Modified By :
// Last Modified On :
// Update Count     :
//

#pragma once

#include <iosfwd>

#include "AST/Node.hpp"
#include "Common/Indenter.h"

namespace ast {

void print( std::ostream & os, const ast::Node * node, Indenter indent = {} );

inline void print( std::ostream & os, const ast::Node * node, unsigned int indent ) {
    print( os, node, Indenter{ Indenter::tabsize, indent });
}

}