% A document class built from the uw-ethesis template, 2017-06-14 version.
% This link should get to the regulations:
% https://uwaterloo.ca/graduate-studies/thesis.
%
% WIP I am still moving things out of the provided template.
%
% This is approximately (check regulations to be sure) the required set up for
% a thesis at UW. It also adds some other pieces that are likely to be useful.
%
% There are several formats you may choose from. These adjust the settings so
% the document comes out a little better for different uses. "digital" is for
% pdf documents that will remain on a computer while "print" is for printing
% paper copies.
%
% Options:
%   <format>
%     All the formats are options, sets the document's format to that format.
%     If no format is given digital is the default.
%
% Exported Names:
%   \ifformat{<format>}{<true>}{<false>}
%     If the document's format is <format> than expands to <true> otherwise
%     expands to <false>.
%
%   \usehyperrefpackage[<options>]{<setup>}
%     Loads the hyperref package with <options> and preforms set up. The
%     initial setup depends on the document format but they can be overriden
%     with options in <setup> (set hyperref's \hypersetup for details).
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{uw-ethesis}[2020/03/24 v0.1 UW-eThesis Template Document Class]

\RequirePackage{etoolbox}

% Requested Format:
\newrobustcmd*{\ethesis@format}{digital}
\DeclareOption{print}{\renewrobustcmd*{\ethesis@format}{print}}
\DeclareOption{digital}{\renewrobustcmd*{\ethesis@format}{digital}}

\ProcessOptions\relax

\newcommand\ifformat[3]{\ifdefstring{\ethesis@format}{#1}{#2}{#3}}

\ifformat{print}{%
  \LoadClass[letterpaper,12pt,titlepage,openright,twoside,final]{book}%
}{%
  \LoadClass[letterpaper,12pt,titlepage,twoside,final]{book}%
}

% Setting up the page margins. These are the minimum margins in the uWaterloo
% thesis requirements. 1in (72pt) on the top, bottom and outside and
% 1 1/8in (81pt) on the inside/gutter/binding side. Only required for
% printing but here set for all formats.

% If margin notes are used, you must adjust \textwidth, \marginparwidth and
% \marginparsep so space between the margin notes and page edge is less than
% 15mm (0.6in). I don't actually understand that instruction.

\setlength{\marginparwidth}{0pt}

% Width of space between body text and margin notes.
\setlength{\marginparsep}{0pt}

% Set width of margin on binding side. With oneside all pages are odd.
\setlength{\evensidemargin}{0.125in}
\setlength{\oddsidemargin}{0.125in}

% Assuming US letter paper (8.5 in. x 11 in.) and side margins as above.
\setlength{\textwidth}{6.375in}
\raggedbottom

% The following statement specifies the amount of space between paragraphs.
% Other reasonable specifications are \bigskipamount and \smallskipamount.
\setlength{\parskip}{\medskipamount}

% The following statement controls the line spacing. You should not change
% this value significantly (e.g. perhaps "1.2").
\renewcommand{\baselinestretch}{1}

% Normally every chapter will start on a recto (right-hand side) page. This
% command is used to make sure the each section of the front pages starts on
% a recto page. This will often require an empty verso (left-hand side) page
% that should not have the page number printed on it.
\let\origdoublepage\cleardoublepage
\newcommand{\clearemptydoublepage}{%
  \clearpage{\pagestyle{empty}\origdoublepage}}
\let\cleardoublepage\clearemptydoublepage

% Change the default name of the bibliography.
\renewcommand*{\bibname}{References}

% Configurations
\def\setThesisTitle#1{\newrobustcmd*{\ethesis@title}{#1}}
\def\setThesisAuthor#1{\newrobustcmd*{\ethesis@author}{#1}}
\def\setThesisSubject#1{\newrobustcmd*{\ethesis@subject}{#1}}
\def\setThesisKeywords#1{\newrobustcmd*{\ethesis@keywords}{#1}}

% Includes the hyperref package loading a number of defaults.
\newrobustcmd*{\usehyperrefpackage}[2][]{%
  \usepackage[#1]{hyperref}
  \hypersetup{
    plainpages=false,       % Needed for Roman numbers in frontpages.
    unicode=false,          % Non-Latin characters in Acrobat ^ ^ s bookmarks.
    pdftoolbar=true,        % Show Acrobat ^ ^ s toolbar?
    pdfmenubar=true,        % Show Acrobat ^ ^ s menu?
    pdffitwindow=false,     % Window is not fit to page when opened.
    pdfstartview={FitH},    % Fits the width of the page to the window.
  }
  \ifdef{\ethesis@title}{\hypersetup{pdftitle={\ethesis@title}}}{}
  \ifdef{\ethesis@author}{\hypersetup{pdfauthor={\ethesis@author}}}{}
  \ifdef{\ethesis@subject}{\hypersetup{pdfsubject={\ethesis@subject}}}{}
  \ifdef{\ethesis@keywords}{\hypersetup{pdfkeywords={\ethesis@keywords}}}{}
  \ifformat{print}{
    \hypersetup{
      %colorlinks=false,
      colorlinks=true, % I think there is a style difference here.
      citecolor=black,
      filecolor=black,
      linkcolor=black,
      urlcolor=black
    }
  }{
    \hypersetup{
      colorlinks=true,        % false: boxed links; true: colored links
      linkcolor=blue,         % colour of internal links
      citecolor=green,        % colour of links to bibliography
      filecolor=magenta,      % colour of file links
      urlcolor=cyan           % colour of external links
    }
  }
  \notblank{#2}{\hypersetup{#2}}{}
}

% Includes the glossaries-extra package and sets up some helpers.
% Except right now I don't really have any helpers to add.
%\newrobustcmd*{\useglossariesextrapackage}[2][]{%
%  \usepackage[#1]{glossaries-extra}
%}

\let\colour=\color
