#include <iostream>
#include <experimental/coroutine>

struct suspend_never {
	bool await_ready() noexcept {
		return true;
	}

	void await_suspend(std::experimental::coroutine_handle<>) noexcept {}
	void await_resume() noexcept {}
};

struct suspend_always {
	bool await_ready() noexcept {
		return false;
	}

	void await_suspend(std::experimental::coroutine_handle<>) noexcept {}
	void await_resume() noexcept {}
};

template<typename T>
struct cor_range {
	struct promise_type {
		T _value;

		cor_range get_return_object() {
			return cor_range(std::experimental::coroutine_handle<promise_type>::from_promise(*this));
		}

		auto initial_suspend() { return suspend_never(); }
		auto final_suspend()   { return suspend_never(); }

		void return_value(T value) {
			_value = value;
		}

		auto yield_value(T value) {
			_value = value;
			return suspend_always();
		}

		void unhandled_exception() {}
	};

	std::experimental::coroutine_handle<promise_type> _coroutine = nullptr;

	explicit cor_range(std::experimental::coroutine_handle<promise_type> coroutine)
		: _coroutine(coroutine)
	{}

	~cor_range() {
		if(_coroutine) { _coroutine.destroy(); }
	}

	cor_range() = default;
	cor_range(cor_range const &) = delete;
	cor_range& operator=(cor_range const &) = delete;

	cor_range(cor_range&& other) {
		std::swap(_coroutine, other._coroutine);
	}

	cor_range& operator=(cor_range&& other) {
		if(&other != this) {
			_coroutine = other._coroutine;
			other._coroutine = nullptr;
		}
		return *this;
	}

	T next() {
		_coroutine.resume();
		return _coroutine.promise()._value;
	}
};

cor_range<int> fib() {
	int fn;
	fn = 0; int fn1 = fn; co_yield fn;
	fn = 1; int fn2 = fn1; fn1 = fn; co_yield fn;
	for(;;) {
		fn = fn1 + fn2; fn2 = fn1; fn1 = fn; co_yield fn;
	}
}

int main() {
	auto f1 = fib();
	auto f2 = fib();
	for(int i = 0; i < 10; i++) {
		std::cout << f1.next() << " " << f2.next() << std::endl;
	}
}