#!/usr/bin/env bash

readonly ALL_TESTS=(cond-match-{all,none} cross-{catch,finally} \
		raise-{detor,empty,finally,other})

gen-file-name() (
	if echo "$1" | grep -q -E '^[^%]*%[^%]*$' -; then
		for L in {a..z}; do
			file_name=${1//%/$L}
			if ! [ -e $file_name ]; then
				break
			fi
		done
		echo $file_name
	else
		echo "$1"
	fi
)

readonly N=${1:-5}
readonly OUT_FILE=$(gen-file-name ${2:-run-%-$N})

run-tests() (
	for ((i = 0 ; i < N ; ++i)); do
		for test in ${ALL_TESTS[@]}; do
			for lang in cfa-t cfa-r cpp java python; do
				./test.sh $lang $test
			done
		done
	done
)

run-tests > $OUT_FILE
