//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// CurrentObject.h --
//
// Author           : Rob Schluntz
// Created On       : Thu Jun  8 11:07:25 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:36:48 2017
// Update Count     : 3
//

#pragma once

#include <vector> // for vector
#include <stack>  // for stack

class Designation;
class Type;
struct InitAlternative;

namespace ResolvExpr {
	class MemberIterator;

	// TODO: memory management of MemberIterators
	class CurrentObject {
	public:
		CurrentObject();
		CurrentObject( Type * type );

		/// resolves unresolved designation
		Designation * findNext( Designation * designation );
		/// sets current position using resolved designation
		void setNext( Designation * designation );
		/// steps to next sub-object of current-object
		void increment();
		/// sets new current-object for the duration of this brace-enclosed initializer-list
		void enterListInit();
		/// restores previous current-object
		void exitListInit();
		/// produces a list of alternatives (Type *, Designation *) for the current sub-object's initializer
		std::vector< InitAlternative > getOptions();
		/// produces the type of the current object but no subobjects
		Type * getCurrentType();

	private:
		std::stack< MemberIterator * > objStack;
	};
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //

