#include <stdio.h>
#include "bench.h"
#include "cfa-stack.h"
#include "cfa-pair.h"
#include "cfa-print.h"

int main( int argc, char *argv[] ) {
	FILE * out = fopen( "/dev/null", "w" );
	int maxi = 0, vali = 42;
	stack(int) si, ti;

	REPEAT_TIMED( "push_int", N, push( si, vali ); )
	TIMED( "copy_int", ti = si; )
	TIMED( "clear_int", clear( si ); )
	REPEAT_TIMED( "pop_int", N,
		int xi = pop( ti );
		if ( xi > maxi ) { maxi = xi; } )
	REPEAT_TIMED( "print_int", N/2, print( out, vali, ":", vali, "\n" ); )

	pair(_Bool, char) maxp = { (_Bool)0, '\0' }, valp = { (_Bool)1, 'a' };
	stack(pair(_Bool, char)) sp, tp;

	REPEAT_TIMED( "push_pair", N, push( sp, valp ); )
	TIMED( "copy_pair", tp = sp; )
	TIMED( "clear_pair", clear( sp ); )
	REPEAT_TIMED( "pop_pair", N,
		pair(_Bool, char) xp = pop( tp );
		if ( xp > maxp ) { maxp = xp; } )
	REPEAT_TIMED( "print_pair", N/2, print( out, valp, ":", valp, "\n" ); )
	fclose(out);
}
