//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Occurs.cc --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 09:47:41 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 17 09:49:26 2015
// Update Count     : 2
//

#include <string>             // for string
#include <unordered_set>      // for unordered_set

#include "Common/PassVisitor.h"
#include "SynTree/Type.h"     // for TypeInstType, Type
#include "TypeEnvironment.h"  // for ClassRef, TypeEnvironment

namespace ResolvExpr {
	struct Occurs : public WithVisitorRef<Occurs> {
		Occurs( std::string varName, const TypeEnvironment &env );
		void previsit( TypeInstType * typeInst );

		bool result;
		using VarSet = std::unordered_set< std::string >;
		VarSet eqvVars;
		const TypeEnvironment &tenv;
	};

	bool occurs( Type *type, std::string varName, const TypeEnvironment &env ) {
		PassVisitor<Occurs> occur( varName, env );
		type->accept( occur );
		return occur.pass.result;
	}

	Occurs::Occurs( std::string varName, const TypeEnvironment & env ) : result( false ), tenv( env ) {
		if ( ClassRef eqvClass = tenv.lookup( varName ) ) {
			eqvVars = eqvClass.get_vars<VarSet>();
		} else {
			eqvVars.insert( varName );
		} // if
	}

	void Occurs::previsit( TypeInstType * typeInst ) {
		///   std::cerr << "searching for vars: ";
///   std::copy( eqvVars.begin(), eqvVars.end(), std::ostream_iterator< std::string >( std::cerr, " " ) );
///   std::cerr << std::endl;
		if ( eqvVars.find( typeInst->get_name() ) != eqvVars.end() ) {
			result = true;
		} else if ( ClassRef eqvClass = tenv.lookup( typeInst->get_name() ) ) {
			if ( Type* boundTy = eqvClass.get_bound().type ) {
///       std::cerr << typeInst->get_name() << " is bound to";
///       boundTy->print( std::cerr );
///       std::cerr << std::endl;
				boundTy->accept( *visitor );
			} // if
		} // if
	}
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
