//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// CastCost.cc --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 06:57:43 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Feb  2 15:34:36 2016
// Update Count     : 7
//

#include <cassert>                       // for assert

#include "ConversionCost.h"              // for ConversionCost
#include "Cost.h"                        // for Cost, Cost::infinity
#include "ResolvExpr/TypeEnvironment.h"  // for TypeEnvironment, ClassRef
#include "SymTab/Indexer.h"              // for Indexer
#include "SynTree/Declaration.h"         // for TypeDecl, NamedTypeDecl
#include "SynTree/Type.h"                // for PointerType, Type, TypeInstType
#include "typeops.h"                     // for typesCompatibleIgnoreQualifiers

#if 0
#define PRINT(x) x
#else
#define PRINT(x)
#endif

namespace ResolvExpr {
	struct CastCost : public ConversionCost {
	  public:
		CastCost( Type *dest, const SymTab::Indexer &indexer, const TypeEnvironment &env, CostFunction costFunc );

		using ConversionCost::previsit;
		using ConversionCost::postvisit;
		void postvisit( BasicType * basicType );
		void postvisit( PointerType * pointerType );
	};

	Cost castCost( Type *src, Type *dest, const SymTab::Indexer &indexer, const TypeEnvironment &env ) {
		if ( TypeInstType *destAsTypeInst = dynamic_cast< TypeInstType* >( dest ) ) {
			if ( ClassRef eqvClass = env.lookup( destAsTypeInst->get_name() ) ) {
				if ( Type* boundTy = eqvClass.get_bound().type ) {
					return castCost( src, boundTy, indexer, env );
				} else {
					return Cost::infinity;
				}
			} else if ( NamedTypeDecl *namedType = indexer.lookupType( destAsTypeInst->get_name() ) ) {
				// all typedefs should be gone by this point
				TypeDecl *type = strict_dynamic_cast< TypeDecl* >( namedType );
				if ( type->base ) {
					return castCost( src, type->base, indexer, env ) + Cost::safe;
				} // if
			} // if
		} // if

		PRINT(
			std::cerr << "castCost ::: src is ";
			src->print( std::cerr );
			std::cerr << std::endl << "dest is ";
			dest->print( std::cerr );
			std::cerr << std::endl << "env is" << std::endl;
			env.print( std::cerr, 8 );
		)

		if ( typesCompatibleIgnoreQualifiers( src, dest, indexer, env ) ) {
			PRINT( std::cerr << "compatible!" << std::endl; )
			return Cost::zero;
		} else if ( dynamic_cast< VoidType* >( dest ) ) {
			return Cost::safe;
		} else if ( ReferenceType * refType = dynamic_cast< ReferenceType * > ( dest ) ) {
			PRINT( std::cerr << "conversionCost: dest is reference" << std::endl; )
			return convertToReferenceCost( src, refType, indexer, env, [](Type * t1, Type * t2, const SymTab::Indexer & indexer, const TypeEnvironment & env ) {
				return ptrsCastable( t1, t2, env, indexer );
			});
		} else {
			PassVisitor<CastCost> converter( dest, indexer, env, castCost );
			src->accept( converter );
			if ( converter.pass.get_cost() == Cost::infinity ) {
				return Cost::infinity;
			} else {
				// xxx - why are we adding cost 0 here?
				return converter.pass.get_cost() + Cost::zero;
			} // if
		} // if
	}

	CastCost::CastCost( Type *dest, const SymTab::Indexer &indexer, const TypeEnvironment &env, CostFunction costFunc )
		: ConversionCost( dest, indexer, env, costFunc ) {
	}

	void CastCost::postvisit( BasicType *basicType ) {
		PointerType *destAsPointer = dynamic_cast< PointerType* >( dest );
		if ( destAsPointer && basicType->isInteger() ) {
			// necessary for, e.g. unsigned long => void*
			cost = Cost::unsafe;
		} else {
			cost = conversionCost( basicType, dest, indexer, env );
		} // if
	}

	void CastCost::postvisit( PointerType *pointerType ) {
		if ( PointerType *destAsPtr = dynamic_cast< PointerType* >( dest ) ) {
			if ( pointerType->get_qualifiers() <= destAsPtr->get_qualifiers() && typesCompatibleIgnoreQualifiers( pointerType->base, destAsPtr->base, indexer, env ) ) {
				cost = Cost::safe;
			} else {
				TypeEnvironment newEnv( env );
				newEnv.add( pointerType->forall );
				newEnv.add( pointerType->base->forall );
				int castResult = ptrsCastable( pointerType->base, destAsPtr->base, newEnv, indexer );
				if ( castResult > 0 ) {
					cost = Cost::safe;
				} else if ( castResult < 0 ) {
					cost = Cost::infinity;
				} // if
			} // if
		} else if ( BasicType *destAsBasic = dynamic_cast< BasicType* >( dest ) ) {
			if ( destAsBasic->isInteger() ) {
				// necessary for, e.g. void* => unsigned long
				cost = Cost::unsafe;
			} // if
		}
	}
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
