#include <fstream>
#include <kernel>
#include <monitor>
#include <stdlib>
#include <thread>

#include <time.h>

static const unsigned long N = 2_500ul;

#ifndef PREEMPTION_RATE
#define PREEMPTION_RATE 10_000ul
#endif

unsigned int default_preemption() {
	return PREEMPTION_RATE;
}

monitor global_t {};

global_t globalA;

thread Acceptor {};
thread Acceptee {};

//----------------------------------------------------------------------------------------------------
// Acceptor
void do_notify( global_t * mutex a );

void do_wait( global_t * mutex a ) {
	sout | "Preparing to wait" | endl;

	__acceptable_t acceptable;
	acceptable.func          = (void_fptr_t)do_notify;
	acceptable.count         = 1;
	acceptable.monitors      = &a;
	acceptable.run_preaccept = false;

	sout | "Waiting for notify" | endl;

	int ret = __accept_internal( 1, &acceptable );
	sout | "Back from wating, accepted" | ret | endl;
}

void main( Acceptor* this ) {
	do_wait( &globalA );
}

//----------------------------------------------------------------------------------------------------
// Acceptee
void do_notify( global_t * mutex a ) {
	sout | "Notifying" | endl;
}

void main( Acceptee* this ) {
	for( volatile int i = 0; i < N; i++ );

	sout | "Call Notify" | endl;
	do_notify( &globalA );
}

//----------------------------------------------------------------------------------------------------
// Main
int main(int argc, char* argv[]) {
	processor p;
	sout | "Starting" | endl;
	{
		Acceptor r;
		Acceptee e;
	}
	sout | "Done" | endl;
}