#include <fstream>
#include <stdlib>
#include <thread>

#include <unistd.h>					// sysconf
#include <sys/times.h>					// times
#include <time.h>

inline unsigned long long int Time() {
    timespec ts;
    clock_gettime(
#if defined( __linux__ )
	 CLOCK_THREAD_CPUTIME_ID,
#elif defined( __freebsd__ )
	 CLOCK_PROF,
#elif defined( __solaris__ )
	 CLOCK_HIGHRES,
#else
    #error uC++ : internal error, unsupported architecture
#endif
	 &ts );
    return 1000000000LL * ts.tv_sec + ts.tv_nsec;
} // Time

#ifndef N
#define N 10000000
#endif

condition condA; 
condition condB;

monitor mon_t {};

mon_t mon1, mon2;

thread thrdA {};
thread thrdB {};

void sideA( mon_t * mutex a, mon_t * mutex b ) {
	long long int StartTime, EndTime;

	StartTime = Time();
	for( int i = 0;; i++ ) {
		signal(&condA);
		if( i > N ) break;
		wait(&condB);
	}
	EndTime = Time();

	sout | ( EndTime - StartTime ) / N | endl;
}

void sideB( mon_t * mutex a, mon_t * mutex b ) {
	for( int i = 0;; i++ ) {
		signal(&condB);
		if( i > N ) break;
		wait(&condA);
	}
}

void main( thrdA * this ) { sideA( &mon1, &mon2 ); }
void main( thrdB * this ) { sideB( &mon1, &mon2 ); }

int main() {
	thrdA a;
	thrdB b;
}