#include <kernel.hfa>
#include <thread.hfa>
#include <time.hfa>

#include <unistd.h>

#include "long_tests.hfa"

#ifndef PREEMPTION_RATE
#error PREEMPTION_RATE not defined in makefile
#endif

Duration default_preemption() {
	return PREEMPTION_RATE;
}

static const unsigned long N = 50_000ul;

int main(int argc, char* argv[]) {
	processor * p[15];
	for ( int pi = 0; pi < 15; pi++ ) {
		p[pi] = new();
	}
	for ( int i = 0; TEST(i < N); i++) {
		int pi = i % 15;
		delete( p[pi] );
		p[pi] = new();
		KICK_WATCHDOG;
	}
	for ( int pi = 0; pi < 15; pi++ ) {
		delete( p[pi] );
	}
}
