//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Constant.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Wed Jun 10 14:41:03 2015
// Update Count     : 8
//

#include <iostream>
#include <list>

#include "Constant.h"
#include "Type.h"

Constant::Constant( Type *type_, std::string value_ ) : type( type_ ), value( value_ ) {}

Constant::~Constant() {}

Constant *Constant::clone() const { return 0; }

void Constant::print( std::ostream &os ) const {
	os << "(" << value;
	if ( type ) {
		os << ": ";
		type->print( os );
	} // if
  os << ")";
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
