#pragma once
#include "object.hpp"

struct stack {
	struct node {
		ptr<object> value;
		node * next;
		node( const object & v, node * n = nullptr );
	};
	node * head;

	void copy( const stack & o );
	void clear();

	stack();
	stack( const stack & o );
	~stack();
	stack & operator=( const stack& o );
	bool empty() const;
	void push( const object & value );
	ptr<object> pop();
};
