//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// debug.h --
//
// Author           : Thierry Delisle
// Created On       : Mon Nov 28 12:27:26 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 10:02:24 2017
// Update Count     : 1
//

#pragma once

#ifdef __CFA_DEBUG__
	#define __cfaabi_dbg_debug_do(...) __VA_ARGS__
	#define __cfaabi_dbg_no_debug_do(...)
	#define __cfaabi_dbg_ctx __PRETTY_FUNCTION__
	#define __cfaabi_dbg_ctx2 , __PRETTY_FUNCTION__
	#define __cfaabi_dbg_ctx_param const char * caller
	#define __cfaabi_dbg_ctx_param2 , const char * caller
#else
	#define __cfaabi_dbg_debug_do(...)
	#define __cfaabi_dbg_no_debug_do(...) __VA_ARGS__
	#define __cfaabi_dbg_ctx
	#define __cfaabi_dbg_ctx2
	#define __cfaabi_dbg_ctx_param
	#define __cfaabi_dbg_ctx_param2
#endif

#ifdef __cforall
extern "C" {
#endif
	#include <stdarg.h>
	#include <stdio.h>

      extern void __cfaabi_dbg_bits_write( const char *buffer, int len );
      extern void __cfaabi_dbg_bits_acquire();
      extern void __cfaabi_dbg_bits_release();
      extern void __cfaabi_dbg_bits_print_safe  ( const char fmt[], ... ) __attribute__(( format (printf, 1, 2) ));
      extern void __cfaabi_dbg_bits_print_nolock( const char fmt[], ... ) __attribute__(( format (printf, 1, 2) ));
      extern void __cfaabi_dbg_bits_print_vararg( const char fmt[], va_list arg );
      extern void __cfaabi_dbg_bits_print_buffer( char buffer[], int buffer_size, const char fmt[], ... ) __attribute__(( format (printf, 3, 4) ));
#ifdef __cforall
}
#endif

#ifdef __CFA_DEBUG_PRINT__
	#define __cfaabi_dbg_write( buffer, len )         __cfaabi_dbg_bits_write( buffer, len )
	#define __cfaabi_dbg_acquire()                    __cfaabi_dbg_bits_acquire()
	#define __cfaabi_dbg_release()                    __cfaabi_dbg_bits_release()
	#define __cfaabi_dbg_print_safe(...)              __cfaabi_dbg_bits_print_safe   (__VA_ARGS__)
	#define __cfaabi_dbg_print_nolock(...)            __cfaabi_dbg_bits_print_nolock (__VA_ARGS__)
	#define __cfaabi_dbg_print_buffer(...)            __cfaabi_dbg_bits_print_buffer (__VA_ARGS__)
	#define __cfaabi_dbg_print_buffer_decl(...)       char __dbg_text[256]; int __dbg_len = snprintf( __dbg_text, 256, __VA_ARGS__ ); __cfaabi_dbg_bits_write( __dbg_text, __dbg_len );
	#define __cfaabi_dbg_print_buffer_local(...)      __dbg_len = snprintf( __dbg_text, 256, __VA_ARGS__ ); __cfaabi_dbg_bits_write( __dbg_text, __dbg_len );
#else
	#define __cfaabi_dbg_write(...)               ((void)0)
	#define __cfaabi_dbg_acquire()                ((void)0)
	#define __cfaabi_dbg_release()                ((void)0)
	#define __cfaabi_dbg_print_safe(...)          ((void)0)
	#define __cfaabi_dbg_print_nolock(...)        ((void)0)
	#define __cfaabi_dbg_print_buffer(...)        ((void)0)
	#define __cfaabi_dbg_print_buffer_decl(...)   ((void)0)
	#define __cfaabi_dbg_print_buffer_local(...)  ((void)0)
#endif

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
