// Throw Across Empty Function
#include <exception>
#include <cstdlib>

struct EmptyException : public std::exception {};

void unwind_empty(unsigned int frames) {
	if (frames) {
		unwind_empty(frames - 1);
	} else {
		throw (EmptyException){};
	}
}

int main(int argc, char * argv[]) {
	unsigned int times = 1;
	unsigned int total_frames = 1;
	if (2 < argc) {
		times = strtol(argv[1], nullptr, 10);
	}
	if (3 < argc) {
		total_frames = strtol(argv[2], nullptr, 10);
	}

	for (unsigned int count = 0 ; count < times ; ++count) {
		try {
			unwind_empty(total_frames);
		} catch (EmptyException &) {
			// ...
		}
	}
}
