#include <kernel.hfa>
#include <thread.hfa>
#include <time.hfa>

#define __kick_rate 550000ul
#include "long_tests.h"

#ifndef PREEMPTION_RATE
#error PREEMPTION_RATE not defined in makefile
#endif

Duration default_preemption() {
	return PREEMPTION_RATE;
}

#ifdef TEST_LONG
static const unsigned long N = 9_750_000ul;
#else
static const unsigned long N = 325_000ul;
#endif

thread worker_t {};

void main(worker_t & this) {
	for(int i = 0; TEST(i < N); i++) {
		yield();
		KICK_WATCHDOG;
	}
}

extern "C" {
static worker_t * workers;
}

int main(int argc, char* argv[]) {
	processor p;
	{
		worker_t w[7];
		workers = w;
	}
}
