//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ConversionCost.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 09:37:28 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:38:24 2017
// Update Count     : 4
//

#pragma once

#include "SynTree/Visitor.h"
#include "SymTab/Indexer.h"
#include "Cost.h"
#include "TypeEnvironment.h"

namespace ResolvExpr {
	class ConversionCost : public Visitor {
	  public:
		ConversionCost( Type *dest, const SymTab::Indexer &indexer, const TypeEnvironment &env );
  
		Cost get_cost() const { return cost; }

		virtual void visit(VoidType *voidType);
		virtual void visit(BasicType *basicType);
		virtual void visit(PointerType *pointerType);
		virtual void visit(ArrayType *arrayType);
		virtual void visit(FunctionType *functionType);
		virtual void visit(StructInstType *aggregateUseType);
		virtual void visit(UnionInstType *aggregateUseType);
		virtual void visit(EnumInstType *aggregateUseType);
		virtual void visit(TraitInstType *aggregateUseType);
		virtual void visit(TypeInstType *aggregateUseType);
		virtual void visit(TupleType *tupleType);
		virtual void visit(VarArgsType *varArgsType);
		virtual void visit(ZeroType *zeroType);
		virtual void visit(OneType *oneType);
	  protected:
		Type *dest;
		const SymTab::Indexer &indexer;
		Cost cost;
		const TypeEnvironment &env;
	};
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
