// 
// Cforall Version 1.0.0 Copyright (C) 2017 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// runningTotal.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Dec  6 08:05:27 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Dec  6 08:09:24 2017
// Update Count     : 2
// 

#include <fstream>
#include <coroutine>

coroutine RunTotal {									// input numbers and return running total
	int input, total;									// communication
};

void ?{}( RunTotal & rntl ) { rntl.total = 0; }

void update( RunTotal & rntl, int input ) with( rntl ) { // helper
	total += input;										// remember between activations
	suspend();											// inactivate on stack
}

void main( RunTotal & rntl ) with( rntl ) {
	for ( ;; ) {
		update( rntl, input );
	} // for
}

int add( RunTotal & rntl, int input ) {
	rntl.input = input;									// pass input to coroutine
	resume( rntl );
	return rntl.total;									// return total from coroutine
}
int main() {
	RunTotal rntl;
	for ( int i = 0; i < 10; i += 1 ) {
		sout | i | add( rntl, i ) | endl;
	} // for
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa runningTotal.c" //
// End: //
